DECLARE SUB TestMask ()
'-------------------------------------------
'MAY 20, 1996  by Michael J. Gothelf
'
'Sample of Masked input code .... Can be linked into a library
'There are NO ROYALTIES.
'
'DISCLAIMER: I am not responsible for SYSTEM failures, use at your own risk.
'-------------------------------------------
DECLARE FUNCTION FindMaskPOS% (StartPointer%, Mask$, Direction%)
DECLARE SUB DeleteChar (KeyPointer%, Mask$, StrINPUT$)
DEFINT A-Z

'$INCLUDE: 'MASKINPT.CAL'

CONST TRUE% = -1, FALSE% = 0    '<- Good to have in all code

'NOTE: The mask types are (#)Numeric digit   ($)Character A-Z,a-z

'-------------------------------------------
CALL TestMask
'-------------------------------------------

'This routine is left open for future enhancements...
'   try to see what you can do with the masking..
'I have left it simple right now..just placing a SPACE at the current
'   location
SUB DeleteChar (KeyPointer%, Mask$, StrINPUT$)
	MID$(StrINPUT$, KeyPointer%, 1) = SPACE$(1)
END SUB

FUNCTION FindMaskPOS% (StartPointer%, Mask$, Direction%)
	FieldLEN% = LEN(Mask$)
	StartAt% = StartPointer% + Direction%
	IF (Direction% = 1) THEN EndAt% = FieldLEN% ELSE EndAt% = 1

	Position% = 0

	MaskTYPES$ = "#$"   '<- These are the available mask types
											'   To speed up this code, insert only the mask types
											'   that you need and modify the call as..
											'   FindMaskPOS%( , , , MaskTYPES$)
	FOR Pointer% = StartAt% TO EndAt% STEP Direction%
		Character$ = MID$(Mask$, Pointer%, 1) '<- Look at 1 byte at a time
		IF (INSTR(MaskTYPES$, Character$) > 0) THEN '<- Is the character a mask?
			Position% = Pointer%                      '   so search is done
			EXIT FOR
		END IF
	NEXT Pointer%

	FindMaskPOS% = Position%
END FUNCTION

'This routine waits for a key input
'This is not a polling routine..
'   Once in you cannot leave until a key is pressed
'KeyCODE% = an ascii code equivalent of the key pressed
'           this routine takes into account EXTENDED key codes
'           these codes are represented as < 0
SUB GetKEYPRESS (KeyPress$, KeyCode%)

	DO: KeyPress$ = INKEY$: LOOP UNTIL LEN(KeyPress$) > 0

	IF (LEN(KeyPress$) > 1) THEN  '<- Extended key code
		KeyCode = -(ASC(RIGHT$(KeyPress$, 1)))  '<- Format is chr$(0)+chr$(key)
	ELSE
		KeyCode = ASC(KeyPress$)
	END IF

END SUB

'This routine will assume that StrINPUT$ has been initialized
'If it is not...StrINPUT$ will be reset to all blanks!
'This is a big piece of code...Print it out on paper and then try reading it!
FUNCTION GetLineInput% (COL%, ROW%, StrINPUT$, Mask$, CharCOLOR%, BackCOLOR%)
	InputLEN% = LEN(Mask$) '<- You can use the mask to set the max # characters
	IF (InputLEN% = 0) THEN EXIT FUNCTION'<- Nothing to do!

	'- Clear the input string??
	IF (LEN(StrINPUT$) <> InputLEN) THEN StrINPUT$ = SPACE$(InputLEN)

	KeyPointer% = 0
	Direction = 1 '<- Move to the right   (-1) will move left
	KeyPointer = FindMaskPOS(KeyPointer, Mask$, Direction)
	IF (KeyPointer = 0) THEN EXIT FUNCTION'<- Nothing to do

	DO
		Skip = FALSE: NewPointer = 0: Direction% = 1: Ok% = FALSE
		
		LOCATE ROW%, COL% + (KeyPointer% - 1), 1  '<- Display the CURSOR
																							'NOTE:,,0 Turns off the CURSOR
		GetKEYPRESS KeyPress$, KeyCode%   '<- Wait for keypress
		
'---Check for editing keys  Add more codes for features...HELP,etc.
		SELECT CASE KeyCode%
			CASE 13:  Done% = TRUE       '<- Enter Key
			CASE 27:  Done% = TRUE       '<- Escape key
			CASE -15: Done% = TRUE       '<- Shift Tab
			CASE 9:   Done% = TRUE       '<- Tab
			CASE 8:   Skip% = TRUE       '<- Back Space
				DeleteChar KeyPointer%, Mask$, StrINPUT$
				PrintSTR COL%, ROW%, StrINPUT$, CharCOLOR%, BackCOLOR%
				Direction% = -1: NewPointer% = FindMaskPOS(KeyPointer%, Mask$, Direction%)
			CASE -83: Skip% = TRUE       '<- Delete Key
				DeleteChar KeyPointer%, Mask$, StrINPUT$
				PrintSTR COL%, ROW%, StrINPUT$, CharCOLOR%, BackCOLOR%
			CASE -77: Skip% = TRUE       '<- Move to the right
				Direction% = 1: NewPointer% = FindMaskPOS(KeyPointer%, Mask$, Direction%)
			CASE -75: Skip% = TRUE       '<- Move to the Left
				Direction% = -1: NewPointer% = FindMaskPOS(KeyPointer%, Mask$, Direction%)
			CASE -72, -80: Done% = TRUE  '<- Up,Down
		END SELECT

'---Check for masked input
		IF NOT (Done) THEN
			IF NOT (Skip) THEN
				SELECT CASE MID$(Mask$, KeyPointer%, 1)
					CASE "#" '<- Integer entry   0-9
						IF KeyPress$ >= "0" AND KeyPress$ <= "9" THEN
							Ok% = TRUE
						ELSEIF (KeyPress$ = " ") THEN
							Ok% = TRUE: KeyPress$ = "0"
						END IF
					CASE "$" '<-Character Entry
						IF UCASE$(KeyPress$) >= "A" AND UCASE$(KeyPress$) <= "Z" THEN
							Ok% = TRUE
						ELSEIF (KeyPress$ = " ") THEN
							Ok% = TRUE
						END IF
					CASE ELSE      '<- Anything not defined is considered a skip position
						NewPointer% = FindMaskPOS(KeyPointer%, Mask$, Direction%)
				END SELECT
				IF Ok% = TRUE THEN
					MID$(StrINPUT$, KeyPointer%, 1) = KeyPress$
					PrintSTR COL% + (KeyPointer% - 1), ROW%, KeyPress$, CharCOLOR%, BackCOLOR%
					NewPointer% = FindMaskPOS(KeyPointer%, Mask$, Direction%)
				END IF
			END IF
		END IF
		IF (NewPointer% > 0) THEN KeyPointer% = NewPointer%
	LOOP UNTIL Done%

	GetLineInput% = KeyCode%
END FUNCTION

FUNCTION Mask2Str$ (DispSTR$, Mask$)
	InputLEN = LEN(Mask$)
	Temp$ = ""
	
	FOR P = 1 TO InputLEN
		MaskKEY$ = MID$(Mask$, P, 1)
		SELECT CASE MaskKEY$
			CASE "#", "$"     '<- Put your mask codes here
				Temp$ = Temp$ + MID$(DispSTR$, P, 1)
		END SELECT
	NEXT P

	Mask2Str$ = Temp$
END FUNCTION

SUB PrintSTR (COL%, ROW%, StrINPUT$, CharCOLOR%, BackCOLOR%)
	LOCATE ROW%, COL%
	COLOR CharCOLOR%, BackCOLOR%
	PRINT StrINPUT$
END SUB

FUNCTION Str2Mask$ (StrINPUT$, Mask$)
	InputLEN = LEN(Mask$)
	Temp$ = SPACE$(InputLEN)
	DataLength = LEN(StrINPUT$)

	StrPointer = 1
	FOR P = 1 TO InputLEN
		MaskKEY$ = MID$(Mask$, P, 1)
		SELECT CASE MaskKEY$
			CASE "#", "$"     '<- Put your mask codes here
				IF (StrPointer <= DataLength) THEN
					MID$(Temp$, P, 1) = MID$(StrINPUT$, StrPointer, 1)
					StrPointer = StrPointer + 1 '<- Pointer to character in Field Data
																			'   Remember, Field Data length can be
																			'   less then the Field Display|input
																			'   length.
				END IF
			CASE ELSE
				MID$(Temp$, P, 1) = MaskKEY$
		END SELECT
	NEXT P

	Str2Mask$ = Temp$
END FUNCTION

SUB TestMask
'------------[MAIN CODE]----------
	CLS

	PRINT "ENTER YOUR PHONE NUMBER: "
	StrINPUT$ = "": Mask$ = "(###)###-####"
	DispSTR$ = Str2Mask$(StrINPUT$, Mask$)

 
	COL% = 26: ROW% = 1    '<- Field Position
	CharCOLOR% = 15: BackCOLOR% = 1
	CALL PrintSTR(COL%, ROW%, DispSTR$, CharCOLOR%, BackCOLOR%)

	TermCode% = GetLineInput%(COL%, ROW%, DispSTR$, Mask$, CharCOLOR%, BackCOLOR%)
	PRINT ""
	StrINPUT$ = Mask2Str$(DispSTR$, Mask$)
	PRINT "["; StrINPUT$; "]"

	'Use TermCode% to determine if you have to move to another field, etc...

	COLOR 7, 0    '<- Reset the color to WHITE on BLACK
	END

END SUB

